﻿var userSelector = {
    datatable: null,
    groupId: 0,
    initializeDataTable: function () {
        this.datatable = $(".h-users-table").a4datatable({
            ajaxAction: a4.getAction("GetUsers", "Users", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Visible": false, "Key": true },
                { "Name": "UserName", "Title": resources.UserName },
                { "Name": "Firstname", "Title": resources.FirstName },
                { "Name": "Lastname", "Title": resources.LastName }
            ],
            allowRowSelection: true,
            rememberRowSelection: true,
            selectedRows: $(".v-selectedUsers").val()
        });
    },

    bindEvents: function () {
        $(document).on("click", ".v-confirmButton", function () {
            var items = userSelector.datatable.a4datatable("getSelectedItems");
            var users = _.pluck(items, "Id").join(",");
            var groupId = $(".v-groupId").val();

            a4.callServerMethod(a4.getAction("UpdateGroupUsers", "Users", "Settings"), { groupId: groupId, userIds: users },
            function (result) {
                modalDialog.close();
            });
        });
    }
}

$(document).ready(function () {
    if ($(".h-users-table").length > 0) {
        userSelector.initializeDataTable();
        userSelector.bindEvents();
    }
});